import { Card, CardContent } from "@/components/ui/card";
import { COMPANY_NAME } from "@/util/constant";

export default function About() {
  const stats = [
    { value: "15+", label: "Years Experience" },
    { value: "50K+", label: "Trucks Sold" },
    { value: "98%", label: "Customer Satisfaction" }
  ];

  return (
    <div className="min-h-screen bg-gray-50 py-16">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
          <div>
            <h1 className="text-3xl lg:text-4xl font-bold text-gray-900 mb-6">{COMPANY_NAME}</h1>
            <p className="text-lg text-neutral mb-6">
              For over 15 years, {COMPANY_NAME} has been the leading marketplace for commercial vehicles, connecting buyers and sellers across the nation. We understand that purchasing a commercial truck is a significant investment, which is why we're committed to providing a transparent, secure, and efficient platform.
            </p>
            <p className="text-lg text-neutral mb-8">
              Our team of industry experts carefully vets every listing, ensuring you have access to quality vehicles and trusted dealers. Whether you're a fleet manager, owner-operator, or business owner, we're here to help you find the perfect commercial vehicle for your needs.
            </p>
            <div className="grid grid-cols-3 gap-6 text-center">
              {stats.map((stat, index) => (
                <div key={index}>
                  <div className="text-3xl font-bold text-primary mb-2">{stat.value}</div>
                  <div className="text-neutral">{stat.label}</div>
                </div>
              ))}
            </div>
          </div>
          <div>
            <img 
              src="https://images.unsplash.com/photo-1560472354-b33ff0c44a43?ixlib=rb-4.0.3&auto=format&fit=crop&w=800&h=600" 
              alt="TruckHub dealership showroom" 
              className="rounded-xl shadow-lg w-full h-auto"
            />
          </div>
        </div>

        {/* Mission and Values */}
        <div className="mt-16 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
          <Card>
            <CardContent className="p-6">
              <h3 className="text-xl font-bold text-gray-900 mb-4">Our Mission</h3>
              <p className="text-neutral">
                To simplify commercial vehicle transactions by providing a trusted, transparent, and efficient marketplace that serves the needs of buyers and sellers nationwide.
              </p>
            </CardContent>
          </Card>

          <Card>
            <CardContent className="p-6">
              <h3 className="text-xl font-bold text-gray-900 mb-4">Our Vision</h3>
              <p className="text-neutral">
                To be the most trusted and comprehensive platform for commercial vehicle transactions, setting the industry standard for quality and customer service.
              </p>
            </CardContent>
          </Card>

          <Card>
            <CardContent className="p-6">
              <h3 className="text-xl font-bold text-gray-900 mb-4">Our Values</h3>
              <p className="text-neutral">
                Integrity, transparency, customer focus, and innovation drive everything we do. We believe in building lasting relationships based on trust and mutual success.
              </p>
            </CardContent>
          </Card>
        </div>

        {/* Team Section */}
        <div className="mt-16">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">Our Team</h2>
            <p className="text-xl text-neutral max-w-2xl mx-auto">
              Meet the dedicated professionals who make TTD the trusted choice for commercial vehicle transactions
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            {[
              {
                name: "Michael Rodriguez",
                role: "CEO & Founder",
                image: "https://images.unsplash.com/photo-1472099645785-5658abf4ff4e?ixlib=rb-4.0.3&auto=format&fit=crop&w=400&h=400",
                bio: "20+ years in commercial vehicle industry"
              },
              {
                name: "Sarah Chen",
                role: "VP of Sales",
                image: "https://images.unsplash.com/photo-1494790108755-2616b612b829?ixlib=rb-4.0.3&auto=format&fit=crop&w=400&h=400",
                bio: "Expert in fleet management and acquisitions"
              },
              {
                name: "David Thompson",
                role: "Technical Director",
                image: "https://images.unsplash.com/photo-1560250097-0b93528c311a?ixlib=rb-4.0.3&auto=format&fit=crop&w=400&h=400",
                bio: "Technology innovation and platform development"
              }
            ].map((member, index) => (
              <Card key={index}>
                <CardContent className="p-6 text-center">
                  <img 
                    src={member.image} 
                    alt={member.name}
                    className="w-32 h-32 rounded-full mx-auto mb-4 object-cover"
                  />
                  <h3 className="text-xl font-bold text-gray-900 mb-2">{member.name}</h3>
                  <p className="text-primary font-medium mb-2">{member.role}</p>
                  <p className="text-neutral text-sm">{member.bio}</p>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>

        {/* Company History */}
        <div className="mt-16">
          <Card>
            <CardContent className="p-8">
              <h2 className="text-3xl font-bold text-gray-900 mb-6 text-center">Our Journey</h2>
              <div className="space-y-6">
                <div className="flex items-start space-x-4">
                  <div className="bg-primary text-white rounded-full w-8 h-8 flex items-center justify-center font-bold text-sm">2009</div>
                  <div>
                    <h3 className="font-semibold text-gray-900">Company Founded</h3>
                    <p className="text-neutral">{COMPANY_NAME} was established with a vision to transform the commercial vehicle marketplace.</p>
                  </div>
                </div>
                
                <div className="flex items-start space-x-4">
                  <div className="bg-primary text-white rounded-full w-8 h-8 flex items-center justify-center font-bold text-sm">2015</div>
                  <div>
                    <h3 className="font-semibold text-gray-900">Platform Expansion</h3>
                    <p className="text-neutral">Launched our comprehensive online platform serving customers nationwide.</p>
                  </div>
                </div>
                
                <div className="flex items-start space-x-4">
                  <div className="bg-primary text-white rounded-full w-8 h-8 flex items-center justify-center font-bold text-sm">2020</div>
                  <div>
                    <h3 className="font-semibold text-gray-900">Digital Innovation</h3>
                    <p className="text-neutral">Introduced advanced search features and mobile-first design for better user experience.</p>
                  </div>
                </div>
                
                <div className="flex items-start space-x-4">
                  <div className="bg-chart-5 text-white rounded-full w-8 h-8 flex items-center justify-center font-bold text-sm">2024</div>
                  <div>
                    <h3 className="font-semibold text-gray-900">Industry Leadership</h3>
                    <p className="text-neutral">Reached 50,000+ successful transactions and became the most trusted platform in the industry.</p>
                  </div>
                </div>
              </div>
            </CardContent>
          </Card>
        </div>
      </div>
    </div>
  );
};
