export default function Loading() {
  return (
    <section className="max-w-7xl mx-auto px-4 py-10">
      <h1 className="text-2xl font-semibold text-center mb-6">Loading Blogs...</h1>
      <div className="grid gap-8 sm:grid-cols-2 lg:grid-cols-3">
        {Array.from({ length: 6 }).map((_, i) => (
          <div key={i} className="animate-pulse p-4 border rounded-md space-y-4 bg-muted">
            <div className="h-48 bg-gray-300 rounded-md" />
            <div className="h-4 bg-gray-300 rounded w-3/4" />
            <div className="h-3 bg-gray-300 rounded w-full" />
            <div className="h-10 bg-gray-300 rounded" />
          </div>
        ))}
      </div>
    </section>
  );
}
