"use client";

import AuthService from "@/service/AuthService";
import { useRouter } from "next/navigation";
import React, { createContext, useState, useEffect } from "react";

const AuthContext = createContext();

export const AuthProvider = ({ children }) => {
  const [user, setUser] = useState(null);
  const router = useRouter();

  // Load on page load
  useEffect(() => {
    const stored = AuthService.getCurrentUser();
    if (stored) {
      setUser(stored);
    }
  }, []);

  // Login flow
  const login = async (username, password) => {
    const data = await AuthService.login(username, password);
    setUser(data);
    return data;
  };

  // Logout flow
  const logout = async () => {
    await AuthService.logout();
    setUser(null);
    router.push('/');
  };

  const isLoggedIn = () => !!user?.token;

  return (
    <AuthContext.Provider value={{ user, login, logout, isLoggedIn }}>
      {children}
    </AuthContext.Provider>
  );
};

export default AuthContext;
