"use client";

import Image from "next/image";
import Link from "next/link";
import {
  CalendarDays,
  Gauge,
  Settings,
  Fuel,
  Ruler,
  DollarSign,
  Eye,
  Zap,
} from "lucide-react";
import { IMAGE_BASE_URL } from "@/util/BaseUrl";
import { useState } from "react";

export default function ListingCard({ listing }) {
  const [currentImageIndex, setCurrentImageIndex] = useState(0);

  const images =
    listing.images && listing.images.length > 0
      ? listing.images.map((img) => `${IMAGE_BASE_URL}/${img}`)
      : ["/no-image.jpg"];

  return (
    <div className="bg-white rounded-lg shadow-md overflow-hidden flex flex-col">
      <div className="relative w-full h-40">
        <Image
          src={images[currentImageIndex]}
          alt={listing.title}
          fill
          className="object-cover"
          sizes="100vw"
        />
        {/* Prev Button */}
        {images.length > 1 && (
          <>
            <button
              onClick={() =>
                setCurrentImageIndex((prev) =>
                  prev === 0 ? images.length - 1 : prev - 1
                )
              }
              className="absolute left-2 top-1/2 -translate-y-1/2 bg-white/70 p-1 rounded-full shadow"
            >
              ◀
            </button>

            {/* Next Button */}
            <button
              onClick={() =>
                setCurrentImageIndex((prev) =>
                  prev === images.length - 1 ? 0 : prev + 1
                )
              }
              className="absolute right-2 top-1/2 -translate-y-1/2 bg-white/70 p-1 rounded-full shadow"
            >
              ▶
            </button>

            {/* Counter */}
            <div className="absolute bottom-2 right-2 bg-black/70 text-white text-xs px-2 py-1 rounded-md">
              {currentImageIndex + 1} / {images.length}
            </div>
          </>
        )}
      </div>

      <div className="p-4 flex-1 flex flex-col">
        <h2 className="text-lg font-bold mb-2">{listing.title}</h2>
        <p className="text-gray-600 flex-1">
          {listing.description?.slice(0, 80)}
          {listing.description?.length > 80 && "..."}
        </p>

        {/* Info Grid */}
        <div className="mt-4 grid grid-cols-2 gap-2 text-sm text-gray-700">
          <div className="flex items-center gap-1">
            <CalendarDays className="w-4 h-4" />
            <span>{listing.year}</span>
          </div>

          {listing.type === "TRUCK" ? (
            <>
              <div className="flex items-center gap-1">
                <Gauge className="w-4 h-4" />
                <span>{listing.truckMileage} mi</span>
              </div>
              <div className="flex items-center gap-1">
                <Zap className="w-4 h-4" />
                <span>{listing.truckHorsePower || "N/A"} hp</span>
              </div>
              <div className="flex items-center gap-1">
                <Fuel className="w-4 h-4" />
                <span>{listing.truckFuelType || "N/A"}</span>
              </div>
            </>
          ) : (
            <>
              <div className="flex items-center gap-1">
                <Settings className="w-4 h-4" />
                <span>{listing.trailerType || "N/A"}</span>
              </div>
              <div className="flex items-center gap-1">
                <Ruler className="w-4 h-4" />
                <span>{listing.trailerLength || "N/A"} mtr</span>
              </div>
              <div className="flex items-center gap-1">
                <Gauge className="w-4 h-4" />
                <span>{listing.trailerNumberOfAxles || "N/A"} axles</span>
              </div>
            </>
          )}
        </div>

        <div className="mt-4 flex justify-between items-center">
          <p className="inline-flex items-center text-base font-bold text-primary">
            <DollarSign className="w-5 h-5" />
            <span className="text-lg">{listing.price}</span>
          </p>

          <Link
            href={`/detail/${listing.id}`}
            className="inline-flex items-center text-sm font-semibold bg-chart-5 text-white px-2 py-1 rounded hover:bg-chart-5/90 transition"
          >
            <Eye className="w-4 h-4 mr-1" /> View Details
          </Link>
        </div>
      </div>
    </div>
  );
}