"use client";

import { useEffect, useState } from "react";
import Link from "next/link";
import { getStateList } from "@/service/LocationService";

const StateLinks = () => {
  const [states, setStates] = useState([]);
  const [loading, setLoading] = useState(true);

  useEffect(() => {
    const fetchStates = async () => {
      try {
        const stateList = await getStateList();
        setStates(stateList);
      } catch (err) {
        console.error("Error loading states:", err);
      } finally {
        setLoading(false);
      }
    };
    fetchStates();
  }, []);

  if (loading) {
    return (
      <div className="py-12 text-center text-gray-500">
        Loading popular states...
      </div>
    );
  }

  return (
    <section className="py-16 bg-gray-50">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <h2 className="text-3xl font-bold text-center mb-10 text-gray-800">
          Search by Popular States
        </h2>

        <div className="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 gap-2">
          {states.map((state) => (
            <Link
              key={state.stateid}
              href={{
                pathname: "/find-trucks",
                query: {
                  state: state.name,
                  country: state.country?.name || "United States",
                  page: 0,
                },
              }}
              className="text-gray-700 hover:text-primary"
            >
              {state.name}
            </Link>
          ))}
        </div>
      </div>
    </section>
  );
};

export default StateLinks;
