import { BLOG_BASE_URL } from "@/util/BaseUrl";
// const WEB_ID = '541c7d80-4ea8-4aa1-a1e7-2a6cbc797e0a';
const WEB_ID = '25d4acf4-2e6c-410e-923c-79e454996d9b';

// Get all blogs with pagination
export const getAllBlogs = async (page = 0, size = 10) => {
  try {
    const url = `${BLOG_BASE_URL}/web?page=${page}&size=${size}&web=${WEB_ID}`;     
    const res = await fetch(url, {next: { revalidate: 60 },});
    
    if (!res.ok) throw new Error("Failed to fetch blogs");

    return await res.json();
  } catch (error) {
    console.error("getAllBlogs error:", error);
    throw error;
  }
};

// Get single blog by title
export const getBlogByTitle = async (title) => {
  try {
    const url = `${BLOG_BASE_URL}/by-title?web=${WEB_ID}&title=${encodeURIComponent(title)}`;
    const res = await fetch(url, {next: { revalidate: 60 }, });

    if (!res.ok) throw new Error("Failed to fetch blog by title");

    return await res.json();
  } catch (error) {
    console.error("getBlogByTitle error:", error);
    throw error;
  }
};
