const LOCATION_API_URL = 'https://nationalusa.net/api/';
const API_KEY = 'a1nm2o55l5';

export const getLocationListByName = async (newLocation) => {
    try {
        const response = await fetch(`${LOCATION_API_URL}getlocationlistbyname?apikey=${API_KEY}&name=${newLocation}`);
        if (!response.ok) {
            throw new Error('Failed to fetch location data');
        }
        const data = await response.json();
        return data.response;
    } catch (error) {
        throw new Error(error.message || 'Failed to get location');
    }
};

export const getStateList = async () => {
    try {
        const response = await fetch(`${LOCATION_API_URL}getstatelist?apikey=${API_KEY}&country=1`);
        if (!response.ok) {
            throw new Error('Failed to fetch State data');
        }
        const data = await response.json();
        return data.response;
    } catch (error) {
        throw new Error(error.message || 'Failed to get State');
    }
};