import { API_BASE_URL } from "@/util/BaseUrl";

const PLAN_API_URL = API_BASE_URL+'/api/plan/';

// Get all plans
export const getAllPlans = async () => {

    const res = await fetch(`${PLAN_API_URL}all`, { next: { revalidate: 60 }, });
    const data = await res.json();

    if (!res.ok) {
        throw new Error(data.message || "Failed to fetch plans");
    }

    return data;
};